<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Rate extends Model 
{

    protected $table = 'rates';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'rateable_id', 'rateable_type', 'rate', 'comment', 'type', 'is_active');

    public function user()
    {
        return $this->belongsTo('App\Models\User');
    }

    public function rateable()
    {
        return $this->morphTo();
    }

}